<%@ page contentType="text/html;charset=ISO-8859-1" language="java" %>
<%@ taglib prefix="core"      uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="stripes"   uri="http://stripes.sourceforge.net/stripes.tld" %>

<html>
    <head><title>An Example of using Contexts and Stripes</title></head>
    <body>
	
	<h1>Hello!</h1>
	<stripes:form action="/ClickCountEcho.action" focus="">
	    <p> Say something, please: <stripes:text name="message" />
		<stripes:submit name="countClicksAndEcho" value="Go!"/>
	    </p>
	</stripes:form>

	<core:if test="${actionBean != null}">
	    <table border="1">
		<tr><th>Context</th><th>Information</th></tr>
		<tr>
		    <td>Application</td>
		    <td>${applicationScope.applicationClicks} submission(s) overall</td>
		</tr>
		<tr>
		    <td>Session</td>
		    <td>${sessionScope.sessionClicks} submission(s) in this session</td>
		</tr>
		<tr><td>Request</td>
		    <td>You said: <i>${actionBean.message}</i></td>
		</tr>
	    </table>	
	</core:if>
    </body>
</html>
