package scopes.action;

import javax.servlet.ServletContext;

import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;

import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;

public class ClickCountEchoAction implements ActionBean {
    private ActionBeanContext context;
    private String message;

    public ActionBeanContext getContext() { return context; }
    public void setContext(ActionBeanContext context) { this.context = context; }

    public String getMessage() { return this.message; }
    public void setMessage(String message) { this.message = message; }

    private void processSessionClicks() {
	Integer sessionClicks = (Integer)getContext().getRequest().getSession().getAttribute("sessionClicks");
	if (sessionClicks == null) {
	    sessionClicks = 0;
	}
	sessionClicks++;
	getContext().getRequest().getSession().setAttribute("sessionClicks", sessionClicks);
    }

    private void processApplicationClicks() {
	ServletContext applicationContext = getContext().getServletContext();

	synchronized (applicationContext) {
	    Integer applicationClicks = (Integer)applicationContext.getAttribute("applicationClicks");
	    if (applicationClicks == null) {
		applicationClicks = 0;
	    }
	    applicationClicks++;
	    applicationContext.setAttribute("applicationClicks", applicationClicks);
	}
    }

    public Resolution countClicksAndEcho() {
	processSessionClicks();
	processApplicationClicks();
	return new ForwardResolution("/default.jsp");
    }
}
