/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.util.Locale;
import java.util.MissingResourceException;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.validation.LocalizableError;

public class ScopedLocalizableError
extends LocalizableError {
    public static final String DEFAULT_NAME = "errorMessage";
    private String defaultScope;
    private String key;

    public ScopedLocalizableError(String defaultScope, String key, Object ... parameters) {
        super(defaultScope + "." + key, parameters);
        this.defaultScope = defaultScope;
        this.key = key;
    }

    protected String getMessageTemplate(Locale locale) {
        String name1 = null;
        String name2 = null;
        String name3 = null;
        String name4 = null;
        String name5 = null;
        String name6 = null;
        String name7 = null;
        name1 = this.getActionPath() + "." + this.getFieldName() + "." + this.key;
        String template = LocalizationUtility.getErrorMessage(locale, name1);
        if (template == null) {
            name2 = this.getActionPath() + "." + this.getFieldName() + "." + DEFAULT_NAME;
            template = LocalizationUtility.getErrorMessage(locale, name2);
        }
        if (template == null) {
            name3 = this.getFieldName() + "." + this.key;
            template = LocalizationUtility.getErrorMessage(locale, name3);
        }
        if (template == null) {
            name4 = this.getFieldName() + "." + DEFAULT_NAME;
            template = LocalizationUtility.getErrorMessage(locale, name4);
        }
        if (template == null) {
            name5 = this.getActionPath() + "." + this.key;
            template = LocalizationUtility.getErrorMessage(locale, name5);
        }
        if (template == null) {
            name6 = this.getActionPath() + "." + DEFAULT_NAME;
            template = LocalizationUtility.getErrorMessage(locale, name6);
        }
        if (template == null) {
            name7 = this.defaultScope + "." + this.key;
            template = LocalizationUtility.getErrorMessage(locale, name7);
        }
        if (template == null) {
            throw new MissingResourceException("Could not find an error message with any of the following keys: '" + name1 + "', '" + name2 + "', '" + name3 + "', '" + name4 + "', '" + name5 + "', '" + name6 + "', '" + name7 + "'.", null, null);
        }
        return template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScopedLocalizableError that = (ScopedLocalizableError)o;
        if (this.defaultScope != null ? !this.defaultScope.equals(that.defaultScope) : that.defaultScope != null) {
            return false;
        }
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.defaultScope != null ? this.defaultScope.hashCode() : 0);
        result = 29 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }
}

