/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBuilder {
    private StringBuilder url = new StringBuilder(256);
    boolean seenQuestionMark = false;
    private String parameterSeparator;
    private String anchor;

    public UrlBuilder(String url, boolean isForPage) {
        if (url != null) {
            int index = url.indexOf(35);
            if (index != -1) {
                this.anchor = url.substring(index + 1);
                url = url.substring(0, index);
            }
            this.url.append(url);
            this.seenQuestionMark = this.url.indexOf("?") != -1;
        }
        this.parameterSeparator = isForPage ? "&amp;" : "&";
    }

    public String getParameterSeparator() {
        return this.parameterSeparator;
    }

    public void setParameterSeparator(String parameterSeparator) {
        this.parameterSeparator = parameterSeparator;
    }

    public void addParameter(String name, Object ... values) {
        try {
            if (values == null || values.length == 0) {
                values = Literal.array("");
            }
            for (Object v : values) {
                if (v instanceof Collection) {
                    this.addParameter(name, ((Collection)v).toArray());
                    continue;
                }
                if (v.getClass().isArray()) {
                    this.addParameter(name, (Object[])v);
                    continue;
                }
                if (!this.seenQuestionMark) {
                    this.url.append('?');
                    this.seenQuestionMark = true;
                } else {
                    this.url.append(this.parameterSeparator);
                }
                this.url.append(name);
                this.url.append('=');
                if (v == null) continue;
                this.url.append(URLEncoder.encode(v.toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new StripesRuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
        }
    }

    public void addParameters(Map<? extends Object, ? extends Object> parameters) {
        for (Map.Entry<? extends Object, ? extends Object> parameter : parameters.entrySet()) {
            Object[] values;
            String name = parameter.getKey().toString();
            Object valueOrValues = parameter.getValue();
            if (valueOrValues == null) {
                this.addParameter(name, new Object[]{null});
                continue;
            }
            if (valueOrValues.getClass().isArray()) {
                values = (Object[])valueOrValues;
                this.addParameter(name, values);
                continue;
            }
            if (valueOrValues instanceof Collection) {
                values = (Collection)valueOrValues;
                this.addParameter(name, new Object[]{values});
                continue;
            }
            this.addParameter(name, valueOrValues);
        }
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor != null && anchor.startsWith("#") && anchor.length() > 1 ? anchor.substring(1) : anchor;
    }

    public String toString() {
        if (this.anchor != null && !"".equals(this.anchor)) {
            return this.url.toString() + "#" + this.anchor;
        }
        return this.url.toString();
    }
}

