/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.util.Arrays;
import net.sourceforge.stripes.util.CollectionUtil;
import org.apache.commons.logging.LogFactory;

public final class Log {
    private org.apache.commons.logging.Log realLog;

    public static Log getInstance(Class clazz) {
        return new Log(LogFactory.getLog((Class)clazz));
    }

    private Log(org.apache.commons.logging.Log realLog) {
        this.realLog = realLog;
    }

    public final void fatal(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isFatalEnabled()) {
            this.realLog.fatal((Object)this.combineParts(messageParts), throwable);
        }
    }

    public final void error(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isErrorEnabled()) {
            this.realLog.error((Object)this.combineParts(messageParts), throwable);
        }
    }

    public final void warn(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isWarnEnabled()) {
            this.realLog.warn((Object)this.combineParts(messageParts), throwable);
        }
    }

    public final void info(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isInfoEnabled()) {
            this.realLog.info((Object)this.combineParts(messageParts), throwable);
        }
    }

    public final void debug(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isDebugEnabled()) {
            this.realLog.debug((Object)this.combineParts(messageParts), throwable);
        }
    }

    public final void trace(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isTraceEnabled()) {
            this.realLog.trace((Object)this.combineParts(messageParts), throwable);
        }
    }

    public final void fatal(Object ... messageParts) {
        if (this.realLog.isFatalEnabled()) {
            this.realLog.fatal((Object)this.combineParts(messageParts));
        }
    }

    public final void error(Object ... messageParts) {
        if (this.realLog.isErrorEnabled()) {
            this.realLog.error((Object)this.combineParts(messageParts));
        }
    }

    public final void warn(Object ... messageParts) {
        if (this.realLog.isWarnEnabled()) {
            this.realLog.warn((Object)this.combineParts(messageParts));
        }
    }

    public final void info(Object ... messageParts) {
        if (this.realLog.isInfoEnabled()) {
            this.realLog.info((Object)this.combineParts(messageParts));
        }
    }

    public final void debug(Object ... messageParts) {
        if (this.realLog.isDebugEnabled()) {
            this.realLog.debug((Object)this.combineParts(messageParts));
        }
    }

    public final void trace(Object ... messageParts) {
        if (this.realLog.isTraceEnabled()) {
            this.realLog.trace((Object)this.combineParts(messageParts));
        }
    }

    private String combineParts(Object[] messageParts) {
        StringBuilder builder = new StringBuilder(128);
        for (Object part : messageParts) {
            if (part instanceof Object[]) {
                builder.append(Arrays.toString(CollectionUtil.asObjectArray(part)));
                continue;
            }
            builder.append(part);
        }
        return builder.toString();
    }
}

