/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Base64;

public class CryptoUtil {
    public static String ALGORITHM = "AES";
    public static String SESSION_ATTR_SECRET_KEY = "__stripes_secret_key";

    public static String encrypt(String input, HttpServletRequest request) {
        if (input == null) {
            return null;
        }
        try {
            Cipher cipher = CryptoUtil.getCipher(request, 1);
            byte[] output = cipher.doFinal(input.getBytes());
            return Base64.encodeBytes(output);
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not encrypt value.", e);
        }
    }

    public static String decrypt(String input, HttpServletRequest request) throws GeneralSecurityException {
        if (input == null) {
            return null;
        }
        byte[] bytes = Base64.decode(input);
        Cipher cipher = CryptoUtil.getCipher(request, 2);
        byte[] output = cipher.doFinal(bytes);
        return new String(output);
    }

    public static Cipher getCipher(HttpServletRequest request, int mode) {
        try {
            HttpSession session = request.getSession();
            SecretKey key = (SecretKey)session.getAttribute(SESSION_ATTR_SECRET_KEY);
            if (key == null) {
                KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM);
                key = kg.generateKey();
                session.setAttribute(SESSION_ATTR_SECRET_KEY, (Object)key);
            }
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(mode, key);
            return cipher;
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not generate a Cipher.", e);
        }
    }
}

