/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StripesTagSupport
implements Tag {
    private static final Log log = Log.getInstance(StripesTagSupport.class);
    protected PageContext pageContext;
    protected Tag parentTag;
    private Map<String, Object> previousAttributeValues;

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void setParent(Tag tag) {
        this.parentTag = tag;
    }

    public Tag getParent() {
        return this.parentTag;
    }

    public abstract int doStartTag() throws JspException;

    public abstract int doEndTag() throws JspException;

    public void release() {
    }

    public void pushPageContextAttributes(Map<String, Object> attributes) {
        this.previousAttributeValues = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String name = entry.getKey();
            this.previousAttributeValues.put(name, this.pageContext.getAttribute(name));
            this.pageContext.setAttribute(name, entry.getValue());
        }
    }

    public void popPageContextAttributes() {
        for (Map.Entry<String, Object> entry : this.previousAttributeValues.entrySet()) {
            if (entry.getValue() == null) {
                this.pageContext.removeAttribute(entry.getKey());
                continue;
            }
            this.pageContext.setAttribute(entry.getKey(), entry.getValue());
        }
        this.previousAttributeValues = null;
    }

    protected <T extends Tag> T getParentTag(Class<T> tagType) {
        for (Tag parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!tagType.isAssignableFrom(parent.getClass())) continue;
            return (T)parent;
        }
        Stack<StripesTagSupport> stack = this.getTagStack();
        ListIterator iterator = stack.listIterator(stack.size());
        while (iterator.hasPrevious()) {
            StripesTagSupport tag = (StripesTagSupport)iterator.previous();
            if (!tagType.isAssignableFrom(tag.getClass())) continue;
            return (T)tag;
        }
        return null;
    }

    protected Stack<StripesTagSupport> getTagStack() {
        Stack stack = (Stack)this.getPageContext().getRequest().getAttribute("__stripes_tag_stack");
        if (stack == null) {
            stack = new Stack();
            this.getPageContext().getRequest().setAttribute("__stripes_tag_stack", stack);
        }
        return stack;
    }

    protected Class<? extends ActionBean> getActionBeanType(Object nameOrClass) {
        Class result = null;
        if (nameOrClass instanceof String) {
            try {
                result = ReflectUtil.findClass((String)nameOrClass);
            }
            catch (ClassNotFoundException cnfe) {
                log.error(cnfe, "Could not find class of type: ", nameOrClass);
                return null;
            }
        } else if (nameOrClass instanceof Class) {
            result = (Class)nameOrClass;
        } else {
            log.error("The value supplied to getActionBeanType() was neither a String nor a Class. Cannot infer ActionBean type from value: " + nameOrClass);
            return null;
        }
        if (ActionBean.class.isAssignableFrom(result)) {
            return result;
        }
        log.error("Class '", result.getName(), "' specified in tag does not implement ", "ActionBean.");
        return null;
    }

    protected String getActionBeanUrl(Object nameOrClass) {
        Class<? extends ActionBean> beanType = this.getActionBeanType(nameOrClass);
        if (beanType != null) {
            return StripesFilter.getConfiguration().getActionResolver().getUrlBinding(beanType);
        }
        return null;
    }
}

