/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.tag.InputOptionTag;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.util.bean.ExpressionException;

public class InputOptionsEnumerationTag
extends HtmlTagSupport
implements Tag {
    private String className;
    private String label;

    public void setEnum(String name) {
        this.className = name;
    }

    public String getEnum() {
        return this.className;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doStartTag() throws JspException {
        Class clazz = null;
        try {
            clazz = ReflectUtil.findClass(this.className);
        }
        catch (Exception e) {
            try {
                int last = this.className.lastIndexOf(46);
                if (last > 0) {
                    String n2 = new StringBuilder(this.className).replace(last, last + 1, "$").toString();
                    clazz = ReflectUtil.findClass(n2);
                }
            }
            catch (Exception e2) {
                throw new StripesJspException("Could not process class [" + this.className + "]. Attribute 'enum' on " + "tag options-enumeration must be the fully qualified name of a " + "class which is a java 1.5 enum.", e);
            }
        }
        if (!clazz.isEnum()) {
            throw new StripesJspException("The class name supplied, [" + this.className + "], does not appear to be " + "a JDK1.5 enum class.");
        }
        Enum[] enums = (Enum[])clazz.getEnumConstants();
        InputOptionTag tag = new InputOptionTag();
        tag.setParent(this);
        tag.setPageContext(this.getPageContext());
        tag.getAttributes().putAll(this.getAttributes());
        tag.getAttributes().remove("enum");
        try {
            Locale locale = this.getPageContext().getRequest().getLocale();
            for (Enum item : enums) {
                String value = item.name();
                Object label = null;
                String packageName = clazz.getPackage() == null ? "" : clazz.getPackage().getName();
                label = LocalizationUtility.getLocalizedFieldName(clazz.getSimpleName() + "." + item.name(), packageName, locale);
                if (label == null) {
                    label = this.label != null ? BeanUtil.getPropertyValue(this.label, item) : item.toString();
                }
                tag.setLabel(label.toString());
                tag.setValue(value);
                try {
                    tag.doStartTag();
                    tag.doInitBody();
                    tag.doAfterBody();
                    tag.doEndTag();
                }
                catch (Throwable t) {
                    try {
                        tag.doCatch(t);
                    }
                    catch (Throwable t2) {
                        if (t2 instanceof JspException) {
                            throw (JspException)t2;
                        }
                        if (t2 instanceof RuntimeException) {
                            throw (RuntimeException)t2;
                        }
                        throw new StripesJspException(t2);
                    }
                }
                finally {
                    tag.doFinally();
                }
            }
        }
        catch (ExpressionException ee) {
            throw new StripesJspException("A problem occurred generating an options-enumeration. Most likely either the class [" + this.getEnum() + "] is not an enum or, [" + this.label + "] is not a valid property of the enum.", ee);
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }
}

