/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.TryCatchFinally;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.Wizard;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.tag.InputCheckBoxTag;
import net.sourceforge.stripes.tag.InputHiddenTag;
import net.sourceforge.stripes.tag.InputSelectTag;
import net.sourceforge.stripes.tag.InputTagSupport;
import net.sourceforge.stripes.tag.WizardFieldsTag;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.HtmlUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTag
extends HtmlTagSupport
implements BodyTag,
TryCatchFinally {
    private static Log log = Log.getInstance(FormTag.class);
    private String focus;
    private boolean focusSet = false;
    private String actionWithoutContext;
    private Map<String, Class> fieldsPresent = new HashMap<String, Class>();

    public void setAction(String action) {
        HttpServletRequest request;
        String contextPath;
        String binding = StripesFilter.getConfiguration().getActionResolver().getUrlBindingFromPath(action);
        this.actionWithoutContext = binding != null ? binding : action;
        if (action.startsWith("/") && (contextPath = (request = (HttpServletRequest)this.getPageContext().getRequest()).getContextPath()) != null && !"/".equals(contextPath) && !action.contains(contextPath + "/")) {
            action = contextPath + action;
        }
        HttpServletResponse response = (HttpServletResponse)this.getPageContext().getResponse();
        this.set("action", response.encodeURL(action));
    }

    public String getAction() {
        return this.actionWithoutContext;
    }

    public void setBeanclass(Object beanclass) throws StripesJspException {
        String url = this.getActionBeanUrl(beanclass);
        if (url == null) {
            throw new StripesJspException("Could not determine action from 'beanclass' supplied. The value supplied was '" + beanclass + "'. Please ensure that this bean type " + "exists and is in the classpath. If you are developing a page and the ActionBean " + "does not yet exist, consider using the 'action' attribute instead for now.");
        }
        this.setAction(url);
    }

    public Object getBeanclass() {
        return null;
    }

    public void setFocus(String focus) {
        this.focus = focus;
    }

    public String getFocus() {
        return this.focus;
    }

    public void setAccept(String accept) {
        this.set("accept", accept);
    }

    public String getAccept() {
        return this.get("accept");
    }

    public void setAcceptcharset(String acceptCharset) {
        this.set("accept-charset", acceptCharset);
    }

    public String getAcceptcharset() {
        return this.get("accept-charset");
    }

    public void setEnctype(String enctype) {
        this.set("enctype", enctype);
    }

    public String getEnctype() {
        return this.get("enctype");
    }

    public void setMethod(String method) {
        this.set("method", method);
    }

    public String getMethod() {
        return this.get("method");
    }

    public void setName(String name) {
        this.set("name", name);
    }

    public String getName() {
        return this.get("name");
    }

    public void setTarget(String target) {
        this.set("target", target);
    }

    public String getTarget() {
        return this.get("target");
    }

    public void setOnreset(String onreset) {
        this.set("onreset", onreset);
    }

    public String getOnreset() {
        return this.get("onreset");
    }

    public void setOnsubmit(String onsubmit) {
        this.set("onsubmit", onsubmit);
    }

    public String getOnsubmit() {
        return this.get("onsubmit");
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.actionWithoutContext == null) {
            throw new StripesJspException("The form tag attributes 'beanClass' and 'action' are both null. One of the two must be supplied to determine which action bean should handle the form submission.");
        }
        this.getTagStack().push(this);
        return 2;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            if (this.getMethod() == null) {
                this.setMethod("post");
            }
            JspWriter out = this.getPageContext().getOut();
            this.writeOpenTag(out, "form");
            this.getBodyContent().writeOut((Writer)this.getPageContext().getOut());
            out.write("<div style=\"display: none;\">");
            out.write("<input type=\"hidden\" name=\"");
            out.write("_sourcePage");
            out.write("\" value=\"");
            HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
            out.write(request.getServletPath());
            out.write("\" />");
            if (this.isWizard()) {
                this.writeWizardFields();
            }
            this.writeFieldsPresentHiddenField(out);
            out.write("</div>");
            this.writeCloseTag(this.getPageContext().getOut(), "form");
            if (this.focus != null && !this.focusSet) {
                log.error("Form with action [", this.getAction(), "] has 'focus' set to '", this.focus, "', but did not find a field with matching name to set focus on.");
            }
            this.fieldsPresent.clear();
            this.focusSet = false;
        }
        catch (IOException ioe) {
            throw new StripesJspException("IOException in FormTag.doEndTag().", ioe);
        }
        return 6;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        try {
            this.getTagStack().pop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void writeFieldsPresentHiddenField(JspWriter out) throws IOException {
        HashSet<String> namesToInclude = new HashSet<String>();
        if (this.isWizard()) {
            namesToInclude.addAll(this.fieldsPresent.keySet());
        } else {
            for (Map.Entry<String, Class> entry : this.fieldsPresent.entrySet()) {
                Class fieldClass = entry.getValue();
                if (!InputSelectTag.class.isAssignableFrom(fieldClass) && !InputCheckBoxTag.class.isAssignableFrom(fieldClass)) continue;
                namesToInclude.add(entry.getKey());
            }
        }
        String hiddenFieldValue = HtmlUtil.combineValues(namesToInclude);
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        hiddenFieldValue = CryptoUtil.encrypt(hiddenFieldValue, request);
        out.write("<input type=\"hidden\" name=\"");
        out.write("__fp");
        out.write("\" value=\"");
        out.write(hiddenFieldValue);
        out.write("\" />");
    }

    protected ActionBean getActionBean() {
        return (ActionBean)this.getPageContext().getRequest().getAttribute(this.actionWithoutContext);
    }

    protected boolean isWizard() {
        ActionBean bean = this.getActionBean();
        Class<Object> clazz = null;
        if (bean == null) {
            clazz = StripesFilter.getConfiguration().getActionResolver().getActionBeanType(this.actionWithoutContext);
            if (clazz == null) {
                log.error("Could not locate an ActionBean that was bound to the URL [", this.actionWithoutContext, "]. Without an ActionBean class Stripes ", "cannot determine whether the ActionBean is a wizard or not. ", "As a result wizard behaviour will be disabled.");
                return false;
            }
        } else {
            clazz = bean.getClass();
        }
        return clazz.getAnnotation(Wizard.class) != null;
    }

    protected void writeWizardFields() throws JspException {
        WizardFieldsTag tag = new WizardFieldsTag();
        tag.setPageContext(this.getPageContext());
        tag.setParent(this);
        tag.doStartTag();
        tag.doEndTag();
        tag.release();
    }

    public void registerField(InputTagSupport tag) {
        this.fieldsPresent.put(tag.getName(), tag.getClass());
        this.setFocusOnFieldIfRequired(tag);
    }

    protected void setFocusOnFieldIfRequired(InputTagSupport tag) {
        if (this.focus != null && !this.focusSet) {
            ValidationErrors errors;
            ActionBean bean = this.getActionBean();
            ValidationErrors validationErrors = errors = bean == null ? null : bean.getContext().getValidationErrors();
            if (errors != null && errors.hasFieldErrors()) {
                List fieldErrors = (List)errors.get(tag.getName());
                if (fieldErrors != null && fieldErrors.size() > 0) {
                    tag.setFocus(true);
                    this.focusSet = true;
                }
            } else if (this.focus.equals(tag.getName())) {
                tag.setFocus(true);
                this.focusSet = true;
            } else if (("".equals(this.focus) || "first".equalsIgnoreCase(this.focus)) && !(tag instanceof InputHiddenTag)) {
                tag.setFocus(true);
                this.focusSet = true;
            }
        }
    }

    public Set<String> getRegisteredFields() {
        return this.fieldsPresent.keySet();
    }
}

