/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.tag.DefaultTagErrorRenderer;
import net.sourceforge.stripes.tag.InputTagSupport;
import net.sourceforge.stripes.tag.TagErrorRenderer;
import net.sourceforge.stripes.tag.TagErrorRendererFactory;
import net.sourceforge.stripes.util.ReflectUtil;

public class DefaultTagErrorRendererFactory
implements TagErrorRendererFactory {
    public static final String RENDERER_CLASS_KEY = "TagErrorRenderer.Class";
    private Configuration configuration;
    private Class<? extends TagErrorRenderer> rendererClass;

    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        String className = configuration.getBootstrapPropertyResolver().getProperty(RENDERER_CLASS_KEY);
        if (className == null) {
            this.rendererClass = DefaultTagErrorRenderer.class;
        } else {
            try {
                this.rendererClass = ReflectUtil.findClass(className);
            }
            catch (ClassNotFoundException cnfe) {
                throw new StripesRuntimeException("Could not load the specified TagErrorRenderer class '" + className + "'. Please check the classname for typos and make " + "sure that the class is available in the classpath of the web app.", cnfe);
            }
        }
    }

    public TagErrorRenderer getTagErrorRenderer(InputTagSupport tag) {
        try {
            TagErrorRenderer renderer = this.rendererClass.newInstance();
            renderer.init(tag);
            return renderer;
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not create an instance of the configured TagErrorRenderer class '" + this.rendererClass.getName() + "'. Please check " + "that the class is public and has a no-arg public constructor.", e);
        }
    }
}

