/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.util.Log;

public class LocalizationUtility {
    private static Log log = Log.getInstance(LocalizationUtility.class);

    public static String getLocalizedFieldName(String fieldName, String actionPath, Locale locale) {
        String name = new ParameterName(fieldName).getStrippedName();
        String localizedValue = null;
        ResourceBundle bundle = null;
        try {
            bundle = StripesFilter.getConfiguration().getLocalizationBundleFactory().getFormFieldBundle(locale);
        }
        catch (MissingResourceException mre) {
            log.error(mre, new Object[0]);
            return null;
        }
        try {
            localizedValue = bundle.getString(actionPath + "." + name);
        }
        catch (MissingResourceException mre) {
            try {
                localizedValue = bundle.getString(name);
            }
            catch (MissingResourceException mre2) {
                return null;
            }
        }
        return localizedValue;
    }

    public static String makePseudoFriendlyName(String fieldNameKey) {
        StringBuilder builder = new StringBuilder(fieldNameKey.length() + 10);
        char[] characters = fieldNameKey.toCharArray();
        builder.append(Character.toUpperCase(characters[0]));
        boolean upcaseNextChar = false;
        for (int i = 1; i < characters.length; ++i) {
            if (characters[i] == '.') {
                builder.append(' ');
                upcaseNextChar = true;
                continue;
            }
            if (Character.isUpperCase(characters[i])) {
                builder.append(' ').append(characters[i]);
                upcaseNextChar = false;
                continue;
            }
            if (upcaseNextChar) {
                builder.append(Character.toUpperCase(characters[i]));
                upcaseNextChar = false;
                continue;
            }
            builder.append(characters[i]);
            upcaseNextChar = false;
        }
        return builder.toString();
    }

    public static String getErrorMessage(Locale locale, String key) {
        try {
            Configuration config = StripesFilter.getConfiguration();
            ResourceBundle bundle = config.getLocalizationBundleFactory().getErrorMessageBundle(locale);
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }
}

