/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.localization;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.localization.LocalePicker;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.StringUtil;

public class DefaultLocalePicker
implements LocalePicker {
    public static final String LOCALE_LIST = "LocalePicker.Locales";
    private final Log log = Log.getInstance(DefaultLocalePicker.class);
    protected Configuration configuration;
    protected List<Locale> locales = new ArrayList<Locale>();
    protected Map<Locale, String> encodings = new HashMap<Locale, String>();

    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        String configuredLocales = configuration.getBootstrapPropertyResolver().getProperty(LOCALE_LIST);
        if (configuredLocales == null || configuredLocales.equals("")) {
            this.log.info("No locale list specified, defaulting to single locale: ", Locale.getDefault());
            this.locales.add(Locale.getDefault());
        } else {
            String[] localeStrings;
            for (String localeString : localeStrings = StringUtil.standardSplit(configuredLocales)) {
                String[] halves = localeString.split(":");
                String[] parts = halves[0].split("[-_]");
                Locale locale = null;
                if (parts.length == 1) {
                    locale = new Locale(parts[0].trim().toLowerCase());
                } else if (parts.length == 2) {
                    locale = new Locale(parts[0].trim().toLowerCase(), parts[1].trim().toUpperCase());
                } else if (parts.length == 3) {
                    locale = new Locale(parts[0].trim().toLowerCase(), parts[1].trim().toUpperCase(), parts[2].trim());
                } else {
                    this.log.error("Configuration property ", LOCALE_LIST, " contained a locale value ", "that split into more than three parts! The parts were: ", parts);
                }
                this.locales.add(locale);
                if (halves.length != 2) continue;
                String encoding = halves[1];
                if (Charset.isSupported(encoding)) {
                    this.encodings.put(locale, halves[1]);
                    continue;
                }
                this.log.error("Configuration property ", LOCALE_LIST, " contained a locale value ", "with an unsupported character encoding. The offending entry is: ", localeString);
            }
            this.log.debug("Configured DefaultLocalePicker with locales: ", this.locales);
            this.log.debug("Configured DefaultLocalePicker with encodings: ", this.encodings);
        }
    }

    public Locale pickLocale(HttpServletRequest request) {
        Locale oneWayMatch = null;
        Locale twoWayMatch = null;
        ArrayList<Locale> preferredLocales = Collections.list(request.getLocales());
        for (Locale preferredLocale : preferredLocales) {
            for (Locale systemLocale : this.locales) {
                if (!systemLocale.getLanguage().equals(preferredLocale.getLanguage())) continue;
                oneWayMatch = oneWayMatch == null ? systemLocale : oneWayMatch;
                String systemCountry = systemLocale.getCountry();
                String preferredCountry = preferredLocale.getCountry();
                if ((systemCountry != null || preferredCountry != null) && (systemCountry == null || !systemCountry.equals(preferredCountry))) continue;
                twoWayMatch = twoWayMatch == null ? systemLocale : twoWayMatch;
                String systemVariant = systemLocale.getVariant();
                String preferredVariant = preferredLocale.getVariant();
                if ((systemVariant != null || preferredVariant != null) && (systemVariant == null || !systemVariant.equals(preferredVariant))) continue;
                return systemLocale;
            }
        }
        if (twoWayMatch != null) {
            return twoWayMatch;
        }
        if (oneWayMatch != null) {
            return oneWayMatch;
        }
        return this.locales.get(0);
    }

    public String pickCharacterEncoding(HttpServletRequest request, Locale locale) {
        return this.encodings.get(locale);
    }
}

