/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.format;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.format.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberFormatter
implements Formatter<Number> {
    protected static final Set<String> namedPatterns = new HashSet<String>();
    private String formatType;
    private String formatPattern;
    private Locale locale;
    private NumberFormat format;

    @Override
    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    @Override
    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void init() {
        if (this.formatType == null) {
            this.formatType = "number";
        }
        if (this.formatPattern == null) {
            this.formatPattern = "plain";
        }
        if (this.formatType.equalsIgnoreCase("number")) {
            this.format = NumberFormat.getInstance(this.locale);
        } else if (this.formatType.equalsIgnoreCase("currency")) {
            this.format = NumberFormat.getCurrencyInstance(this.locale);
        } else if (this.formatType.equalsIgnoreCase("percentage")) {
            this.format = NumberFormat.getPercentInstance(this.locale);
        } else {
            throw new StripesRuntimeException("Invalid format type supplied for formatting a number: " + this.formatType + ". Valid values are 'number', 'currency' " + "and 'percentage'.");
        }
        if (this.formatPattern.equalsIgnoreCase("plain")) {
            this.format.setGroupingUsed(false);
        } else if (this.formatPattern.equalsIgnoreCase("integer")) {
            this.format.setMaximumFractionDigits(0);
        } else if (this.formatPattern.equalsIgnoreCase("decimal")) {
            this.format.setMinimumFractionDigits(2);
            this.format.setMaximumFractionDigits(6);
        } else {
            try {
                ((DecimalFormat)this.format).applyPattern(this.formatPattern);
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Custom pattern could not be applied to NumberFormat instance.  Pattern was: " + this.formatPattern, e);
            }
        }
    }

    @Override
    public String format(Number input) {
        return this.format.format(input);
    }

    static {
        namedPatterns.add("plain");
        namedPatterns.add("integer");
        namedPatterns.add("decimal");
    }
}

