/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.format;

import java.util.Date;
import java.util.Locale;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.format.DateFormatter;
import net.sourceforge.stripes.format.EnumFormatter;
import net.sourceforge.stripes.format.Formatter;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.format.NumberFormatter;

public class DefaultFormatterFactory
implements FormatterFactory {
    private Configuration configuration;

    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public Formatter getFormatter(Class clazz, Locale locale, String formatType, String formatPattern) {
        Formatter<Date> formatter = null;
        if (Date.class.isAssignableFrom(clazz)) {
            formatter = new DateFormatter();
            formatter.setFormatType(formatType);
            formatter.setFormatPattern(formatPattern);
            formatter.setLocale(locale);
            formatter.init();
            return formatter;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            formatter = new NumberFormatter();
            formatter.setFormatType(formatType);
            formatter.setFormatPattern(formatPattern);
            formatter.setLocale(locale);
            formatter.init();
            return formatter;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            formatter = new EnumFormatter();
            formatter.init();
            return formatter;
        }
        return null;
    }
}

