/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller.multipart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.controller.FileUploadLimitExceededException;
import net.sourceforge.stripes.controller.multipart.MultipartWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsMultipartWrapper
implements MultipartWrapper {
    private Map<String, FileItem> files = new HashMap<String, FileItem>();
    private Map<String, String[]> parameters = new HashMap<String, String[]>();
    private String charset;

    @Override
    public void build(HttpServletRequest request, File tempDir, long maxPostSize) throws IOException, FileUploadLimitExceededException {
        try {
            ArrayList<String> values;
            this.charset = request.getCharacterEncoding();
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setRepository(tempDir);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setSizeMax(maxPostSize);
            List items = upload.parseRequest(request);
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            for (FileItem fileItem : items) {
                if (fileItem.isFormField()) {
                    values = (ArrayList<String>)params.get(fileItem.getFieldName());
                    if (values == null) {
                        values = new ArrayList<String>();
                        params.put(fileItem.getFieldName(), values);
                    }
                    values.add(this.charset == null ? fileItem.getString() : fileItem.getString(this.charset));
                    continue;
                }
                this.files.put(fileItem.getFieldName(), fileItem);
            }
            for (Map.Entry entry : params.entrySet()) {
                values = (List)entry.getValue();
                this.parameters.put((String)entry.getKey(), values.toArray(new String[values.size()]));
            }
        }
        catch (FileUploadBase.SizeLimitExceededException slee) {
            throw new FileUploadLimitExceededException(maxPostSize, slee.getActualSize());
        }
        catch (FileUploadException fue) {
            IOException ioe = new IOException("Could not parse and cache file upload data.");
            ioe.initCause(fue);
            throw ioe;
        }
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return new IteratorEnumeration(this.parameters.keySet().iterator());
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return new IteratorEnumeration(this.files.keySet().iterator());
    }

    @Override
    public FileBean getFileParameterValue(String name) {
        final FileItem item = this.files.get(name);
        if (item == null) {
            return null;
        }
        return new FileBean(null, item.getContentType(), item.getName()){

            public long getSize() {
                return item.getSize();
            }

            public InputStream getInputStream() throws IOException {
                return item.getInputStream();
            }

            public void save(File toFile) throws IOException {
                try {
                    item.write(toFile);
                    this.delete();
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    IOException ioe = new IOException("Problem saving uploaded file.");
                    ioe.initCause(e);
                    throw ioe;
                }
            }

            public void delete() throws IOException {
                item.delete();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorEnumeration
    implements Enumeration<String> {
        Iterator<String> iterator;

        IteratorEnumeration(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }
}

