/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.multipart.MultipartWrapper;
import net.sourceforge.stripes.exception.StripesServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripesRequestWrapper
extends HttpServletRequestWrapper {
    private MultipartWrapper multipart;
    private Locale locale;

    public static StripesRequestWrapper findStripesWrapper(ServletRequest request) {
        while (!(request instanceof StripesRequestWrapper) && request != null && request instanceof HttpServletRequestWrapper) {
            request = ((HttpServletRequestWrapper)request).getRequest();
        }
        if (request instanceof StripesRequestWrapper) {
            return (StripesRequestWrapper)request;
        }
        throw new IllegalStateException("A request made it through to some part of Stripes without being wrapped in a StripesRequestWrapper. The StripesFilter is responsible for wrapping the request, so it is likely that either the StripesFilter is not deployed, or that it's mappings do not include the DispatcherServlet _and_ *.jsp. Stripes does not requiire that the Stripes wrapper is the only request wrapper, or the outermost; only that is is present.");
    }

    public StripesRequestWrapper(HttpServletRequest request) throws StripesServletException {
        super(request);
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            this.constructMultipartWrapper(request);
        }
    }

    protected void constructMultipartWrapper(HttpServletRequest request) throws StripesServletException {
        try {
            this.multipart = StripesFilter.getConfiguration().getMultipartWrapperFactory().wrap(request);
        }
        catch (IOException e) {
            throw new StripesServletException("Could not construct request wrapper.", e);
        }
    }

    public boolean isMultipart() {
        return this.multipart != null;
    }

    public Enumeration<String> getParameterNames() {
        if (this.isMultipart()) {
            return this.multipart.getParameterNames();
        }
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (this.isMultipart()) {
            return this.multipart.getParameterValues(name);
        }
        return super.getParameterValues(name);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        if (this.isMultipart()) {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            Enumeration<String> names = this.multipart.getParameterNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                parameterMap.put(name, this.getParameterValues(name));
            }
            return parameterMap;
        }
        return super.getParameterMap();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getLocales() {
        ArrayList<Locale> list = new ArrayList<Locale>();
        list.add(this.locale);
        return Collections.enumeration(list);
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Enumeration<String> getFileParameterNames() {
        return this.multipart.getFileParameterNames();
    }

    public FileBean getFileParameterValue(String name) {
        if (this.multipart != null) {
            return this.multipart.getFileParameterValue(name);
        }
        return null;
    }
}

