/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.AnnotatedClassActionResolver;
import net.sourceforge.stripes.controller.DefaultViewActionBean;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Literal;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameBasedActionResolver
extends AnnotatedClassActionResolver {
    public static final Set<String> BASE_PACKAGES = Collections.unmodifiableSet(Literal.set("web", "www", "stripes", "action"));
    public static final String DEFAULT_BINDING_SUFFIX = ".action";
    private static final Log log = Log.getInstance(NameBasedActionResolver.class);

    @Override
    public void init(Configuration configuration) throws Exception {
        super.init(configuration);
        this.addActionBean(DefaultViewActionBean.class);
    }

    @Override
    public String getUrlBinding(Class<? extends ActionBean> clazz) {
        String binding = super.getUrlBinding(clazz);
        if (binding == null && !Modifier.isAbstract(clazz.getModifiers())) {
            binding = this.getUrlBinding(clazz.getName());
        }
        return binding;
    }

    protected String getUrlBinding(String name) {
        for (String base : this.getBasePackages()) {
            int i = name.indexOf("." + base + ".");
            if (i != -1) {
                name = name.substring(i + base.length() + 1);
                continue;
            }
            if (!name.startsWith(base + ".")) continue;
            name = name.substring(base.length());
        }
        if (name.endsWith("Bean")) {
            name = name.substring(0, name.length() - 4);
        }
        if (name.endsWith("Action")) {
            name = name.substring(0, name.length() - 6);
        }
        if (!(name = name.replace('.', '/')).startsWith("/")) {
            name = "/" + name;
        }
        name = name + this.getBindingSuffix();
        return name;
    }

    protected Set<String> getBasePackages() {
        return BASE_PACKAGES;
    }

    protected String getBindingSuffix() {
        return DEFAULT_BINDING_SUFFIX;
    }

    @Override
    public String getHandledEvent(Method handler) {
        String name = super.getHandledEvent(handler);
        if (name == null && !Modifier.isAbstract(handler.getModifiers()) && Resolution.class.isAssignableFrom(handler.getReturnType())) {
            name = handler.getName();
        }
        return name;
    }

    @Override
    public ActionBean getActionBean(ActionBeanContext context, String urlBinding) throws StripesServletException {
        try {
            return super.getActionBean(context, urlBinding);
        }
        catch (StripesServletException sse) {
            ActionBean bean = this.handleActionBeanNotFound(context, urlBinding);
            if (bean != null) {
                bean.setContext(context);
                return bean;
            }
            throw sse;
        }
    }

    protected ActionBean handleActionBeanNotFound(ActionBeanContext context, String urlBinding) {
        DefaultViewActionBean bean = null;
        Resolution view = this.findView(urlBinding);
        if (view != null) {
            log.debug("Could not find an ActionBean bound to '", urlBinding, "', but found a view ", "at '", view, "'. Forwarding the user there instead.");
            bean = new DefaultViewActionBean(view);
        }
        return bean;
    }

    protected Resolution findView(String urlBinding) {
        String path;
        int lastPeriod = urlBinding.lastIndexOf(46);
        String name = lastPeriod >= (path = urlBinding.substring(0, urlBinding.lastIndexOf("/") + 1)).length() ? urlBinding.substring(path.length(), lastPeriod) : urlBinding.substring(path.length());
        ServletContext ctx = StripesFilter.getConfiguration().getBootstrapPropertyResolver().getFilterConfig().getServletContext();
        try {
            String jsp = path + name + ".jsp";
            if (ctx.getResource(jsp) != null) {
                return new ForwardResolution(jsp);
            }
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            jsp = path + name + ".jsp";
            if (ctx.getResource(jsp) != null) {
                return new ForwardResolution(jsp);
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isUpperCase(ch)) {
                    builder.append("_");
                    builder.append(Character.toLowerCase(ch));
                    continue;
                }
                builder.append(ch);
            }
            jsp = path + builder.toString() + ".jsp";
            if (ctx.getResource(jsp) != null) {
                return new ForwardResolution(jsp);
            }
            return null;
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }
}

