/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionBeanContextFactory;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.ReflectUtil;

public class DefaultActionBeanContextFactory
implements ActionBeanContextFactory {
    public static final String CONTEXT_CLASS_NAME = "ActionBeanContext.Class";
    private Configuration configuration;
    private Class<? extends ActionBeanContext> contextClass;

    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        String name = configuration.getBootstrapPropertyResolver().getProperty(CONTEXT_CLASS_NAME);
        this.contextClass = name != null ? ReflectUtil.findClass(name) : ActionBeanContext.class;
    }

    public ActionBeanContext getContextInstance(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            ActionBeanContext context = this.contextClass.newInstance();
            context.setRequest(request);
            context.setResponse(response);
            return context;
        }
        catch (Exception e) {
            throw new StripesServletException("Could not instantiate configured ActionBeanContext class: " + this.contextClass, e);
        }
    }
}

