/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.SessionScope;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.config.BootstrapPropertyResolver;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionClassCache;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ResolverUtil;
import net.sourceforge.stripes.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedClassActionResolver
implements ActionResolver {
    private static final String URL_FILTERS = "ActionResolver.UrlFilters";
    private static final String PACKAGE_FILTERS = "ActionResolver.PackageFilters";
    private static final String DEFAULT_HANDLER_KEY = "__default_handler";
    private Log log = Log.getInstance(AnnotatedClassActionResolver.class);
    private Configuration configuration;
    private Map<String, Class<? extends ActionBean>> formBeans = new HashMap<String, Class<? extends ActionBean>>();
    private Map<Class<? extends ActionBean>, Map<String, Method>> eventMappings = new HashMap<Class<? extends ActionBean>, Map<String, Method>>();

    @Override
    public void init(Configuration configuration) throws Exception {
        this.configuration = configuration;
        Set<Class<? extends ActionBean>> beans = this.findClasses(ActionBean.class);
        ActionClassCache.init(beans);
        for (Class<? extends ActionBean> clazz : beans) {
            this.addActionBean(clazz);
        }
    }

    protected void addActionBean(Class<? extends ActionBean> clazz) {
        String binding = this.getUrlBinding(clazz);
        if (binding != null) {
            this.formBeans.put(binding, clazz);
            HashMap<String, Method> classMappings = new HashMap<String, Method>();
            this.processMethods(clazz, classMappings);
            this.eventMappings.put(clazz, classMappings);
            for (Map.Entry entry : classMappings.entrySet()) {
                String event = (String)entry.getKey();
                Method handler = (Method)entry.getValue();
                boolean isDefault = DEFAULT_HANDLER_KEY.equals(event);
                this.log.debug("Bound: ", clazz.getSimpleName(), ".", handler.getName(), "() ==> ", binding, isDefault ? "" : "?" + event);
            }
        }
    }

    @Override
    public String getUrlBindingFromPath(String path) {
        String binding = null;
        while (binding == null && path != null) {
            if (this.formBeans.containsKey(path)) {
                binding = path;
                continue;
            }
            int lastSlash = path.lastIndexOf("/");
            if (lastSlash > 0) {
                path = path.substring(0, lastSlash);
                continue;
            }
            path = null;
        }
        return binding;
    }

    @Override
    public String getUrlBinding(Class<? extends ActionBean> clazz) {
        UrlBinding binding = clazz.getAnnotation(UrlBinding.class);
        if (binding != null) {
            return binding.value();
        }
        return null;
    }

    protected void processMethods(Class clazz, Map<String, Method> classMappings) {
        Method[] methods;
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.processMethods(superclass, classMappings);
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            String eventName = this.getHandledEvent(method);
            DefaultHandler defaultMapping = method.getAnnotation(DefaultHandler.class);
            if (eventName != null) {
                classMappings.put(eventName, method);
            }
            if (defaultMapping == null) continue;
            classMappings.put(DEFAULT_HANDLER_KEY, method);
        }
    }

    @Override
    public String getHandledEvent(Method handler) {
        HandlesEvent mapping = handler.getAnnotation(HandlesEvent.class);
        if (mapping != null) {
            return mapping.value();
        }
        return null;
    }

    @Override
    public Class<? extends ActionBean> getActionBeanType(String path) {
        return this.formBeans.get(this.getUrlBindingFromPath(path));
    }

    @Override
    public ActionBean getActionBean(ActionBeanContext context) throws StripesServletException {
        HttpServletRequest request = context.getRequest();
        String path = this.getRequestedPath(request);
        ActionBean bean = this.getActionBean(context, path);
        request.setAttribute("__stripes_resolved_action", (Object)this.getUrlBindingFromPath(path));
        return bean;
    }

    protected String getRequestedPath(HttpServletRequest request) {
        String servletPath = null;
        String pathInfo = null;
        if (request.getAttribute("javax.servlet.include.servlet_path") != null) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        } else {
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        return (servletPath == null ? "" : servletPath) + (pathInfo == null ? "" : pathInfo);
    }

    @Override
    public ActionBean getActionBean(ActionBeanContext context, String path) throws StripesServletException {
        String urlBinding = this.getUrlBindingFromPath(path);
        Class<? extends ActionBean> beanClass = this.formBeans.get(urlBinding);
        if (beanClass == null) {
            throw new StripesServletException("Could not locate an ActionBean that is bound to the URL [" + path + "]. Commons reasons for this include mis-matched URLs and forgetting " + "to implement ActionBean in your class. Registered ActionBeans are: " + this.formBeans);
        }
        try {
            ActionBean bean;
            HttpServletRequest request = context.getRequest();
            if (beanClass.isAnnotationPresent(SessionScope.class)) {
                bean = (ActionBean)request.getSession().getAttribute(path);
                if (bean == null) {
                    bean = this.makeNewActionBean(beanClass, context);
                    request.getSession().setAttribute(path, (Object)bean);
                }
                bean.setContext(context);
            } else {
                bean = (ActionBean)request.getAttribute(path);
                if (bean == null) {
                    bean = this.makeNewActionBean(beanClass, context);
                    bean.setContext(context);
                    request.setAttribute(path, (Object)bean);
                }
            }
            return bean;
        }
        catch (Exception e) {
            StripesServletException sse = new StripesServletException("Could not create instance of ActionBean type [" + beanClass.getName() + "].", e);
            this.log.error((Throwable)((Object)sse), new Object[0]);
            throw sse;
        }
    }

    protected ActionBean makeNewActionBean(Class<? extends ActionBean> type, ActionBeanContext context) throws Exception {
        return type.newInstance();
    }

    @Override
    public String getEventName(Class<? extends ActionBean> bean, ActionBeanContext context) {
        String event = this.getEventNameFromRequestParams(bean, context);
        if (event == null) {
            event = this.getEventNameFromPath(bean, context);
        }
        if (event == null) {
            event = this.getEventNameFromEventNameParam(bean, context);
        }
        return event;
    }

    protected String getEventNameFromRequestParams(Class<? extends ActionBean> bean, ActionBeanContext context) {
        Map parameterMap = context.getRequest().getParameterMap();
        for (String event : this.eventMappings.get(bean).keySet()) {
            if (!parameterMap.containsKey(event) && !parameterMap.containsKey(event + ".x")) continue;
            return event;
        }
        return null;
    }

    protected String getEventNameFromPath(Class<? extends ActionBean> bean, ActionBeanContext context) {
        String extra;
        String event;
        Map<String, Method> mappings = this.eventMappings.get(bean);
        String path = this.getRequestedPath(context.getRequest());
        String binding = this.getUrlBindingFromPath(path);
        if (binding != null && path.length() != binding.length() && mappings.containsKey(event = (extra = path.substring(binding.length() + 1)).substring(0, Math.max(extra.indexOf("/"), extra.length())))) {
            return event;
        }
        return null;
    }

    protected String getEventNameFromEventNameParam(Class<? extends ActionBean> bean, ActionBeanContext context) {
        String[] name = context.getRequest().getParameterValues("_eventName");
        if (name != null && name.length == 1 && this.eventMappings.get(bean).containsKey(name[0])) {
            return name[0];
        }
        return null;
    }

    @Override
    public Method getHandler(Class<? extends ActionBean> bean, String eventName) throws StripesServletException {
        Map<String, Method> mappings = this.eventMappings.get(bean);
        Method handler = mappings.get(eventName);
        if (handler == null) {
            throw new StripesServletException("Could not find handler method for event name [" + eventName + "] on class [" + bean.getName() + "].  Known handler mappings are: " + mappings);
        }
        return handler;
    }

    @Override
    public Method getDefaultHandler(Class<? extends ActionBean> bean) throws StripesServletException {
        Map<String, Method> handlers = this.eventMappings.get(bean);
        if (handlers.size() == 1) {
            return handlers.values().iterator().next();
        }
        Method handler = handlers.get(DEFAULT_HANDLER_KEY);
        if (handler != null) {
            return handler;
        }
        throw new StripesServletException("No default handler could be found for ActionBean of type: " + bean.getName());
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Set<String> getUrlFilters() {
        BootstrapPropertyResolver bootstrap = this.configuration.getBootstrapPropertyResolver();
        HashSet<String> urlFilters = new HashSet<String>();
        String temp = bootstrap.getProperty(URL_FILTERS);
        if (temp != null) {
            urlFilters.addAll(Arrays.asList(StringUtil.standardSplit(temp)));
        }
        return urlFilters;
    }

    protected Set<String> getPackageFilters() {
        BootstrapPropertyResolver bootstrap = this.configuration.getBootstrapPropertyResolver();
        HashSet<String> packageFilters = new HashSet<String>();
        String temp = bootstrap.getProperty(PACKAGE_FILTERS);
        if (temp != null) {
            packageFilters.addAll(Arrays.asList(StringUtil.standardSplit(temp)));
        }
        return packageFilters;
    }

    protected <T> Set<Class<? extends T>> findClasses(Class<T> parentType) {
        ResolverUtil<T> resolver = new ResolverUtil<T>();
        resolver.setPackageFilters(this.getPackageFilters());
        resolver.setLocationFilters(this.getUrlFilters());
        if (!resolver.loadImplementationsFromContextClassloader(parentType)) {
            ServletContext context = this.configuration.getBootstrapPropertyResolver().getFilterConfig().getServletContext();
            resolver.loadImplementationsFromServletContext(parentType, context);
        }
        return resolver.getClasses();
    }
}

