/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.stripes.config.ConfigurableComponent;
import net.sourceforge.stripes.config.DefaultConfiguration;
import net.sourceforge.stripes.controller.ActionBeanContextFactory;
import net.sourceforge.stripes.controller.ActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.multipart.MultipartWrapperFactory;
import net.sourceforge.stripes.exception.ExceptionHandler;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.localization.LocalePicker;
import net.sourceforge.stripes.localization.LocalizationBundleFactory;
import net.sourceforge.stripes.tag.PopulationStrategy;
import net.sourceforge.stripes.tag.TagErrorRendererFactory;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.util.StringUtil;
import net.sourceforge.stripes.validation.TypeConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeConfiguration
extends DefaultConfiguration {
    private static final Log log = Log.getInstance(RuntimeConfiguration.class);
    public static final String ACTION_RESOLVER = "ActionResolver.Class";
    public static final String ACTION_BEAN_PROPERTY_BINDER = "ActionBeanPropertyBinder.Class";
    public static final String ACTION_BEAN_CONTEXT_FACTORY = "ActionBeanContextFactory.Class";
    public static final String TYPE_CONVERTER_FACTORY = "TypeConverterFactory.Class";
    public static final String LOCALIZATION_BUNDLE_FACTORY = "LocalizationBundleFactory.Class";
    public static final String LOCALE_PICKER = "LocalePicker.Class";
    public static final String FORMATTER_FACTORY = "FormatterFactory.Class";
    public static final String TAG_ERROR_RENDERER_FACTORY = "TagErrorRendererFactory.Class";
    public static final String POPULATION_STRATEGY = "PopulationStrategy.Class";
    public static final String EXCEPTION_HANDLER = "ExceptionHandler.Class";
    public static final String MULTIPART_WRAPPER_FACTORY = "MultipartWrapperFactory.Class";
    public static final String INTERCEPTOR_LIST = "Interceptor.Classes";

    @Override
    protected ActionResolver initActionResolver() {
        return this.initializeComponent(ActionResolver.class, ACTION_RESOLVER);
    }

    @Override
    protected ActionBeanPropertyBinder initActionBeanPropertyBinder() {
        return this.initializeComponent(ActionBeanPropertyBinder.class, ACTION_BEAN_PROPERTY_BINDER);
    }

    @Override
    protected ActionBeanContextFactory initActionBeanContextFactory() {
        return this.initializeComponent(ActionBeanContextFactory.class, ACTION_BEAN_CONTEXT_FACTORY);
    }

    @Override
    protected TypeConverterFactory initTypeConverterFactory() {
        return this.initializeComponent(TypeConverterFactory.class, TYPE_CONVERTER_FACTORY);
    }

    @Override
    protected LocalizationBundleFactory initLocalizationBundleFactory() {
        return this.initializeComponent(LocalizationBundleFactory.class, LOCALIZATION_BUNDLE_FACTORY);
    }

    @Override
    protected LocalePicker initLocalePicker() {
        return this.initializeComponent(LocalePicker.class, LOCALE_PICKER);
    }

    @Override
    protected FormatterFactory initFormatterFactory() {
        return this.initializeComponent(FormatterFactory.class, FORMATTER_FACTORY);
    }

    @Override
    protected TagErrorRendererFactory initTagErrorRendererFactory() {
        return this.initializeComponent(TagErrorRendererFactory.class, TAG_ERROR_RENDERER_FACTORY);
    }

    @Override
    protected PopulationStrategy initPopulationStrategy() {
        return this.initializeComponent(PopulationStrategy.class, POPULATION_STRATEGY);
    }

    @Override
    protected ExceptionHandler initExceptionHandler() {
        return this.initializeComponent(ExceptionHandler.class, EXCEPTION_HANDLER);
    }

    @Override
    protected MultipartWrapperFactory initMultipartWrapperFactory() {
        return this.initializeComponent(MultipartWrapperFactory.class, MULTIPART_WRAPPER_FACTORY);
    }

    @Override
    protected Map<LifecycleStage, Collection<Interceptor>> initInterceptors() {
        String classList = this.getBootstrapPropertyResolver().getProperty(INTERCEPTOR_LIST);
        if (classList == null) {
            return null;
        }
        String[] classNames = StringUtil.standardSplit(classList);
        HashMap<LifecycleStage, Collection<Interceptor>> map = new HashMap<LifecycleStage, Collection<Interceptor>>();
        for (String className : classNames) {
            try {
                Class type = ReflectUtil.findClass(className.trim());
                Intercepts intercepts = type.getAnnotation(Intercepts.class);
                if (intercepts == null) {
                    log.error("An interceptor of type ", type.getName(), " was configured ", "but was not marked with an @Intercepts annotation. As a ", "result it is not possible to determine at which ", "lifecycle stages the interceprot should be applied. This ", "interceptor will be ignored.");
                } else {
                    log.debug(new Object[]{"Configuring interceptor '", type.getSimpleName(), "', for lifecycle stages: ", intercepts.value()});
                }
                Interceptor interceptor = (Interceptor)type.newInstance();
                if (interceptor instanceof ConfigurableComponent) {
                    ((ConfigurableComponent)((Object)interceptor)).init(this);
                }
                for (LifecycleStage stage : intercepts.value()) {
                    LinkedList<Interceptor> stack = (LinkedList<Interceptor>)map.get((Object)stage);
                    if (stack == null) {
                        stack = new LinkedList<Interceptor>();
                        map.put(stage, stack);
                    }
                    stack.add(interceptor);
                }
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Could not instantiate one or more configured Interceptors. The property 'Interceptor.Classes' contained [" + classList + "]. This value must contain fully qualified class names separated " + "by commas.", e);
            }
        }
        return map;
    }

    protected <T extends ConfigurableComponent> T initializeComponent(Class<T> componentType, String propertyName) {
        String className = this.getBootstrapPropertyResolver().getProperty(propertyName);
        if (className != null) {
            String componentTypeName = componentType.getSimpleName();
            try {
                log.info("Found configured ", componentTypeName, " class [", className, "], attempting to instantiate and initialize.");
                ConfigurableComponent component = (ConfigurableComponent)ReflectUtil.findClass(className).newInstance();
                component.init(this);
                return (T)component;
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Could not instantiate configured " + componentTypeName + " of type [" + className + "]. Please check " + "the configuration parameters specified in your web.xml.", e);
            }
        }
        return null;
    }
}

