/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.config.BootstrapPropertyResolver;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ActionBeanContextFactory;
import net.sourceforge.stripes.controller.ActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.ActionResolver;
import net.sourceforge.stripes.controller.BeforeAfterMethodInterceptor;
import net.sourceforge.stripes.controller.DefaultActionBeanContextFactory;
import net.sourceforge.stripes.controller.DefaultActionBeanPropertyBinder;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.NameBasedActionResolver;
import net.sourceforge.stripes.controller.multipart.DefaultMultipartWrapperFactory;
import net.sourceforge.stripes.controller.multipart.MultipartWrapperFactory;
import net.sourceforge.stripes.exception.DefaultExceptionHandler;
import net.sourceforge.stripes.exception.ExceptionHandler;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.format.DefaultFormatterFactory;
import net.sourceforge.stripes.format.FormatterFactory;
import net.sourceforge.stripes.localization.DefaultLocalePicker;
import net.sourceforge.stripes.localization.DefaultLocalizationBundleFactory;
import net.sourceforge.stripes.localization.LocalePicker;
import net.sourceforge.stripes.localization.LocalizationBundleFactory;
import net.sourceforge.stripes.tag.DefaultPopulationStrategy;
import net.sourceforge.stripes.tag.DefaultTagErrorRendererFactory;
import net.sourceforge.stripes.tag.PopulationStrategy;
import net.sourceforge.stripes.tag.TagErrorRendererFactory;
import net.sourceforge.stripes.validation.DefaultTypeConverterFactory;
import net.sourceforge.stripes.validation.TypeConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
implements Configuration {
    private BootstrapPropertyResolver resolver;
    private ActionResolver actionResolver;
    private ActionBeanPropertyBinder actionBeanPropertyBinder;
    private ActionBeanContextFactory actionBeanContextFactory;
    private TypeConverterFactory typeConverterFactory;
    private LocalizationBundleFactory localizationBundleFactory;
    private LocalePicker localePicker;
    private FormatterFactory formatterFactory;
    private TagErrorRendererFactory tagErrorRendererFactory;
    private PopulationStrategy populationStrategy;
    private Map<LifecycleStage, Collection<Interceptor>> interceptors;
    private ExceptionHandler exceptionHandler;
    private MultipartWrapperFactory multipartWrapperFactory;

    @Override
    public void setBootstrapPropertyResolver(BootstrapPropertyResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void init() {
        try {
            this.actionResolver = this.initActionResolver();
            if (this.actionResolver == null) {
                this.actionResolver = new NameBasedActionResolver();
                this.actionResolver.init(this);
            }
            this.actionBeanPropertyBinder = this.initActionBeanPropertyBinder();
            if (this.actionBeanPropertyBinder == null) {
                this.actionBeanPropertyBinder = new DefaultActionBeanPropertyBinder();
                this.actionBeanPropertyBinder.init(this);
            }
            this.actionBeanContextFactory = this.initActionBeanContextFactory();
            if (this.actionBeanContextFactory == null) {
                this.actionBeanContextFactory = new DefaultActionBeanContextFactory();
                this.actionBeanContextFactory.init(this);
            }
            this.typeConverterFactory = this.initTypeConverterFactory();
            if (this.typeConverterFactory == null) {
                this.typeConverterFactory = new DefaultTypeConverterFactory();
                this.typeConverterFactory.init(this);
            }
            this.localizationBundleFactory = this.initLocalizationBundleFactory();
            if (this.localizationBundleFactory == null) {
                this.localizationBundleFactory = new DefaultLocalizationBundleFactory();
                this.localizationBundleFactory.init(this);
            }
            this.localePicker = this.initLocalePicker();
            if (this.localePicker == null) {
                this.localePicker = new DefaultLocalePicker();
                this.localePicker.init(this);
            }
            this.formatterFactory = this.initFormatterFactory();
            if (this.formatterFactory == null) {
                this.formatterFactory = new DefaultFormatterFactory();
                this.formatterFactory.init(this);
            }
            this.tagErrorRendererFactory = this.initTagErrorRendererFactory();
            if (this.tagErrorRendererFactory == null) {
                this.tagErrorRendererFactory = new DefaultTagErrorRendererFactory();
                this.tagErrorRendererFactory.init(this);
            }
            this.populationStrategy = this.initPopulationStrategy();
            if (this.populationStrategy == null) {
                this.populationStrategy = new DefaultPopulationStrategy();
                this.populationStrategy.init(this);
            }
            this.exceptionHandler = this.initExceptionHandler();
            if (this.exceptionHandler == null) {
                this.exceptionHandler = new DefaultExceptionHandler();
                this.exceptionHandler.init(this);
            }
            this.multipartWrapperFactory = this.initMultipartWrapperFactory();
            if (this.multipartWrapperFactory == null) {
                this.multipartWrapperFactory = new DefaultMultipartWrapperFactory();
                this.multipartWrapperFactory.init(this);
            }
            this.interceptors = this.initInterceptors();
            if (this.interceptors == null) {
                this.interceptors = new HashMap<LifecycleStage, Collection<Interceptor>>();
                Class<BeforeAfterMethodInterceptor> bam = BeforeAfterMethodInterceptor.class;
                BeforeAfterMethodInterceptor interceptor = new BeforeAfterMethodInterceptor();
                for (LifecycleStage stage : bam.getAnnotation(Intercepts.class).value()) {
                    ArrayList<BeforeAfterMethodInterceptor> instances = new ArrayList<BeforeAfterMethodInterceptor>();
                    instances.add(interceptor);
                    this.interceptors.put(stage, instances);
                }
            }
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Problem instantiating default configuration objects.", e);
        }
    }

    @Override
    public BootstrapPropertyResolver getBootstrapPropertyResolver() {
        return this.resolver;
    }

    @Override
    public ServletContext getServletContext() {
        return this.getBootstrapPropertyResolver().getFilterConfig().getServletContext();
    }

    @Override
    public ActionResolver getActionResolver() {
        return this.actionResolver;
    }

    protected ActionResolver initActionResolver() {
        return null;
    }

    @Override
    public ActionBeanPropertyBinder getActionBeanPropertyBinder() {
        return this.actionBeanPropertyBinder;
    }

    protected ActionBeanPropertyBinder initActionBeanPropertyBinder() {
        return null;
    }

    @Override
    public ActionBeanContextFactory getActionBeanContextFactory() {
        return this.actionBeanContextFactory;
    }

    protected ActionBeanContextFactory initActionBeanContextFactory() {
        return null;
    }

    @Override
    public TypeConverterFactory getTypeConverterFactory() {
        return this.typeConverterFactory;
    }

    protected TypeConverterFactory initTypeConverterFactory() {
        return null;
    }

    @Override
    public LocalizationBundleFactory getLocalizationBundleFactory() {
        return this.localizationBundleFactory;
    }

    protected LocalizationBundleFactory initLocalizationBundleFactory() {
        return null;
    }

    @Override
    public LocalePicker getLocalePicker() {
        return this.localePicker;
    }

    protected LocalePicker initLocalePicker() {
        return null;
    }

    @Override
    public FormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    protected FormatterFactory initFormatterFactory() {
        return null;
    }

    @Override
    public TagErrorRendererFactory getTagErrorRendererFactory() {
        return this.tagErrorRendererFactory;
    }

    protected TagErrorRendererFactory initTagErrorRendererFactory() {
        return null;
    }

    @Override
    public PopulationStrategy getPopulationStrategy() {
        return this.populationStrategy;
    }

    protected PopulationStrategy initPopulationStrategy() {
        return null;
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    protected ExceptionHandler initExceptionHandler() {
        return null;
    }

    @Override
    public MultipartWrapperFactory getMultipartWrapperFactory() {
        return this.multipartWrapperFactory;
    }

    protected MultipartWrapperFactory initMultipartWrapperFactory() {
        return null;
    }

    @Override
    public Collection<Interceptor> getInterceptors(LifecycleStage stage) {
        Collection<Interceptor> interceptors = this.interceptors.get((Object)stage);
        if (interceptors == null) {
            interceptors = Collections.emptyList();
        }
        return interceptors;
    }

    protected Map<LifecycleStage, Collection<Interceptor>> initInterceptors() {
        return null;
    }
}

