/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.ajax;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptBuilder {
    static Log log = Log.getInstance(JavaScriptBuilder.class);
    static Set<Class<?>> simpleTypes = new HashSet();
    static Set<Class<?>> ignoredTypes = new HashSet();
    private Set<Integer> visitedIdentities = new HashSet<Integer>();
    private Map<String, String> objectValues = new HashMap<String, String>();
    private Map<String, String> assignments = new HashMap<String, String>();
    private Object rootObject;
    private Set<Class<?>> excludeClasses;

    public JavaScriptBuilder(Object root, Class<?> ... userClassesToExclude) {
        this.rootObject = root;
        this.excludeClasses = new HashSet();
        for (Class<?> type : userClassesToExclude) {
            this.excludeClasses.add(type);
        }
        this.excludeClasses.addAll(ignoredTypes);
    }

    public String build() {
        StringWriter writer = new StringWriter();
        this.build(writer);
        return ((Object)writer).toString();
    }

    public void build(Writer writer) {
        try {
            if (this.isScalarType(this.rootObject)) {
                writer.write(this.getScalarAsString(this.rootObject));
                writer.write(";\n");
                return;
            }
            String rootName = "_sj_root_" + new Random().nextInt(Integer.MAX_VALUE);
            this.buildNode(rootName, this.rootObject);
            writer.write("var ");
            writer.write(rootName);
            writer.write(";\n");
            for (Map.Entry<String, String> entry : this.objectValues.entrySet()) {
                writer.append("var ");
                writer.append(entry.getKey());
                writer.append(" = ");
                writer.append(entry.getValue());
                writer.append(";\n");
            }
            for (Map.Entry<String, String> entry : this.assignments.entrySet()) {
                writer.append(entry.getKey());
                writer.append(" = ");
                writer.append(entry.getValue());
                writer.append(";\n");
            }
            writer.append(rootName).append(";\n");
        }
        catch (Exception e) {
            throw new StripesRuntimeException("Could not build JavaScript for object. An exception was thrown while trying to convert a property from Java to JavaScript. The object being converted is: " + this.rootObject, e);
        }
    }

    public boolean isExcludedType(Class<?> type) {
        for (Class<?> excludedType : this.excludeClasses) {
            if (excludedType.isAssignableFrom(type)) {
                return true;
            }
            if (!type.isArray() || !excludedType.isAssignableFrom(type.getComponentType())) continue;
            return true;
        }
        return false;
    }

    public boolean isScalarType(Object in) {
        if (in == null) {
            return true;
        }
        Class<?> type = in.getClass();
        return simpleTypes.contains(type) || Number.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type);
    }

    public String getScalarAsString(Object in) {
        if (in == null) {
            return "null";
        }
        Class<?> type = in.getClass();
        if (String.class.isAssignableFrom(type)) {
            return JavaScriptBuilder.quote((String)in);
        }
        if (Date.class.isAssignableFrom(type)) {
            return "new Date(" + ((Date)in).getTime() + ")";
        }
        return in.toString();
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 10);
        sb.append('\"');
        block8: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u");
                        String hex = Integer.toHexString(c);
                        int pad = 4 - hex.length();
                        for (int j = 0; j < pad; ++j) {
                            sb.append("0");
                        }
                        sb.append(hex);
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    void buildNode(String name, Object in) throws Exception {
        int systemId = System.identityHashCode(in);
        String targetName = "_sj_" + systemId;
        if (this.visitedIdentities.contains(systemId)) {
            this.assignments.put(name, targetName);
        } else if (!this.isExcludedType(in.getClass())) {
            this.visitedIdentities.add(systemId);
            if (Collection.class.isAssignableFrom(in.getClass())) {
                this.buildCollectionNode(targetName, (Collection)in);
            } else if (in.getClass().isArray()) {
                this.buildArrayNode(targetName, in);
            } else if (Map.class.isAssignableFrom(in.getClass())) {
                this.buildMapNode(targetName, (Map)in);
            } else {
                this.buildObjectNode(targetName, in);
            }
            this.assignments.put(name, targetName);
        }
    }

    void buildObjectNode(String targetName, Object in) throws Exception {
        PropertyDescriptor[] props;
        StringBuilder out = new StringBuilder();
        out.append("{");
        for (PropertyDescriptor property : props = Introspector.getBeanInfo(in.getClass()).getPropertyDescriptors()) {
            try {
                Method readMethod = property.getReadMethod();
                if (readMethod == null) continue;
                Object value = property.getReadMethod().invoke(in, new Object[0]);
                if (this.isExcludedType(property.getPropertyType()) || value == null) continue;
                if (this.isScalarType(value)) {
                    if (out.length() > 1) {
                        out.append(", ");
                    }
                    out.append(property.getName());
                    out.append(":");
                    out.append(this.getScalarAsString(value));
                    continue;
                }
                this.buildNode(targetName + "." + property.getName(), value);
            }
            catch (Exception e) {
                log.warn(e, "Could not translate property [", property.getName(), "] of type [", property.getPropertyType().getName(), "] due to an exception.");
            }
        }
        if (Enum.class.isAssignableFrom(in.getClass())) {
            Enum e = (Enum)in;
            if (out.length() > 1) {
                out.append(", ");
            }
            out.append("ordinal:").append(this.getScalarAsString(e.ordinal()));
            out.append(", name:").append(this.getScalarAsString(e.name()));
        }
        out.append("}");
        this.objectValues.put(targetName, out.toString());
    }

    void buildMapNode(String targetName, Map<?, ?> in) throws Exception {
        StringBuilder out = new StringBuilder();
        out.append("{");
        for (Map.Entry<?, ?> entry : in.entrySet()) {
            String propertyName = this.getScalarAsString(entry.getKey());
            Object value = entry.getValue();
            if (this.isScalarType(value)) {
                if (out.length() > 1) {
                    out.append(", ");
                }
                out.append(propertyName);
                out.append(":");
                out.append(this.getScalarAsString(value));
                continue;
            }
            this.buildNode(targetName + "[" + propertyName + "]", value);
        }
        out.append("}");
        this.objectValues.put(targetName, out.toString());
    }

    void buildArrayNode(String targetName, Object in) throws Exception {
        StringBuilder out = new StringBuilder();
        out.append("[");
        int length = Array.getLength(in);
        for (int i = 0; i < length; ++i) {
            Object value = Array.get(in, i);
            if (this.isScalarType(value)) {
                out.append(this.getScalarAsString(value));
            } else {
                out.append("null");
                this.buildNode(targetName + "[" + i + "]", value);
            }
            if (i == length - 1) continue;
            out.append(", ");
        }
        out.append("]");
        this.objectValues.put(targetName, out.toString());
    }

    void buildCollectionNode(String targetName, Collection in) throws Exception {
        this.buildArrayNode(targetName, in.toArray());
    }

    static {
        simpleTypes.add(Byte.TYPE);
        simpleTypes.add(Short.TYPE);
        simpleTypes.add(Integer.TYPE);
        simpleTypes.add(Long.TYPE);
        simpleTypes.add(Float.TYPE);
        simpleTypes.add(Double.TYPE);
        simpleTypes.add(Boolean.TYPE);
        ignoredTypes.add(Class.class);
    }
}

