/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.action;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileBean {
    private String contentType;
    private String fileName;
    private File file;
    private boolean saved;

    public FileBean(File file, String contentType, String originalName) {
        this.file = file;
        this.contentType = contentType;
        this.fileName = originalName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getSize() {
        return this.file.length();
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void save(File toFile) throws IOException {
        if (!this.file.exists()) {
            throw new IOException("Some time between uploading and saving we lost the file " + this.file.getAbsolutePath() + " - where did it go?.");
        }
        if (!this.file.canWrite()) {
            throw new IOException("Some time between uploading and saving we lost the ability to write to the file " + this.file.getAbsolutePath() + " - writability is required to move the file.");
        }
        File parent = toFile.getAbsoluteFile().getParentFile();
        if (toFile.exists() && !toFile.canWrite()) {
            throw new IOException("Cannot overwrite existing file at " + toFile.getAbsolutePath());
        }
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Parent directory of specified file does not exist and cannot  be created. File location supplied: " + toFile.getAbsolutePath());
        }
        if (!toFile.exists() && !parent.canWrite()) {
            throw new IOException("Cannot create new file at location: " + toFile.getAbsolutePath());
        }
        this.saved = this.file.renameTo(toFile);
        if (!this.saved) {
            this.saveViaCopy(toFile);
        }
    }

    protected void saveViaCopy(File toFile) throws IOException {
        int b;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile));
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        in.close();
        out.close();
        this.file.delete();
        this.saved = true;
    }

    public void delete() throws IOException {
        if (!this.saved) {
            if (!this.file.exists()) {
                throw new IOException("Some time between uploading and saving we lost the file " + this.file.getAbsolutePath() + " - where did it go?.");
            }
            if (!this.file.canWrite()) {
                throw new IOException("Some time between uploading and saving we lost the ability to write to the file " + this.file.getAbsolutePath() + " - writability is required to delete the file.");
            }
            this.file.delete();
        }
    }

    public String toString() {
        return "FileBean{contentType='" + this.contentType + "'" + ", fileName='" + this.fileName + "'" + "}";
    }
}

